#!/bin/bash

set -e

echo "✨ Convirtiendo antiX base en un sistema i3 puro..."

# 1. Eliminar SLiM (sí viene en antiX base)
sudo apt remove --purge slim -y

# 2. Eliminar Openbox si no lo quieres (opcional, descomenta si quieres borrarlo)
# sudo apt remove --purge openbox obconf menu -y

# 3. Eliminar apps gráficas ligeras (opcional)
# sudo apt remove --purge pcmanfm leafpad nitrogen antix-artwork-* -y

# 4. Instalar lightdm + i3
sudo apt update
sudo apt install --no-install-recommends lightdm i3 -y

# 5. Asegurar que lightdm es el display manager
sudo dpkg-reconfigure lightdm  # ← esto te pedirá elegir lightdm (hazlo manual si es en script)

# Como estamos en script, forzamos:
echo "/usr/sbin/lightdm" | sudo tee /etc/X11/default-display-manager

# 6. Habilitar lightdm en sysvinit (antiX no usa systemd)
sudo update-rc.d lightdm enable 2345

# 7. Limpiar
sudo apt autoremove --purge -y
sudo apt clean

# 8. (Opcional) Crear config básica de i3 para el usuario actual
if [ -d "/home/$USER" ] && [ ! -f "/home/$USER/.config/i3/config" ]; then
    mkdir -p /home/$USER/.config/i3
    cp /etc/i3/config /home/$USER/.config/i3/config 2>/dev/null || i3-config-wizard > /home/$USER/.config/i3/config
    chown -R "$USER":"$USER" /home/$USER/.config/i3
fi

echo ""
echo "✅ ¡Hecho!"
echo "• SLiM eliminado."
echo "• lightdm + i3 instalados."
echo "• Sistema listo para i3 puro."
echo ""
echo "🔄 Reinicia o ejecuta: sudo service lightdm start"